/*                      - IO51FX.H -

   Special header for the 8XC51FX Processor.

*/

#pragma language=extended

/*===============================*/
/* Predefined SFR Byte Addresses */
/*===============================*/

sfr   P0     	= 0x80;
sfr   P1     	= 0x90;
sfr   P2     	= 0xA0;
sfr   P3     	= 0xB0;
sfr   PSW    	= 0xD0;
sfr   ACC    	= 0xE0;
sfr   B      	= 0xF0;
sfr   SP     	= 0x81;
sfr   DPL    	= 0x82;
sfr   DPH    	= 0x83;
sfr   PCON   	= 0x87;
sfr   TCON   	= 0x88;
sfr   TMOD   	= 0x89;
sfr   TL0    	= 0x8A;
sfr   TL1    	= 0x8B;
sfr   TH0    	= 0x8C;
sfr   TH1    	= 0x8D;
sfr   IE     	= 0xA8;
sfr   IP     	= 0xB8;
sfr   IPH       = 0xB7;         /* 2-й регистр приоритетов прерываний */
sfr   SCON   	= 0x98;
sfr   SBUF   	= 0x99;

sfr   SADDR  	= 0xA9;
sfr   SADEN  	= 0xB9;
sfr   T2CON  	= 0xC8;
sfr   T2MOD  	= 0xC9;
sfr   RCAP2L 	= 0xCA;
sfr   RCAP2H 	= 0xCB;
sfr   TL2    	= 0xCC;
sfr   TH2    	= 0xCD;
sfr   CCON      = 0xD8;         /* регистр управления PCA */
sfr   CMOD      = 0xD9;         /* регистр режима     PCA */
sfr   CCAPM0    = 0xDA;         /* регистр режима модуля 0 PCA */
sfr   CCAPM1    = 0xDB;         /*                       1     */
sfr   CCAPM2    = 0xDC;         /*                       2     */
sfr   CCAPM3    = 0xDD;         /*                       3     */
sfr   CCAPM4    = 0xDE;         /*                       4     */
sfr   CL        = 0xE9;         /* мл. байт таймера/счетчика PCA */
sfr   CCAP0L    = 0xEA;         /* мл. байт регистра фиксации модуля 0 PCA */
sfr   CCAP1L    = 0xEB;         /* мл.                               1 PCA */
sfr   CCAP2L    = 0xEC;         /* мл.                               2 PCA */
sfr   CCAP3L    = 0xED;         /* мл.                               3 PCA */
sfr   CCAP4L    = 0xEE;         /* мл.                               4 PCA */
sfr   CH        = 0xF9;         /* ст. байт таймера/счетчика PCA */
sfr   CCAP0H    = 0xFA;         /* ст. байт регистра фиксации модуля 0 PCA */
sfr   CCAP1H    = 0xFB;         /* ст.                               1 PCA */
sfr   CCAP2H    = 0xFC;         /* ст.                               2 PCA */
sfr   CCAP3H    = 0xFD;         /* ст.                               3 PCA */
sfr   CCAP4H    = 0xFE;         /* ст.                               4 PCA */

/*==============================*/
/* Predefined SFR Bit Addresses */
/*==============================*/

/*========PSW=========*/

bit   CY     	= 0xD7;
bit   AC     	= 0xD6;
bit   F0     	= 0xD5;
bit   RS1    	= 0xD4;
bit   RS0    	= 0xD3;
bit   OV     	= 0xD2;
bit   P      	= 0xD0;

/*========TCON========*/

bit   TF1    	= 0x8F;
bit   TR1    	= 0x8E;
bit   TF0    	= 0x8D;
bit   TR0    	= 0x8C;
bit   IE1    	= 0x8B;
bit   IT1    	= 0x8A;
bit   IE0    	= 0x89;
bit   IT0    	= 0x88;

/*=========IE=========*/

bit   EA     	= 0xAF;
bit   EC        = 0xAE;         /* прерывание от PCA  */
bit   ET2       = 0xAD;         /* прерывание от C/T2 */
bit   ES        = 0xAC;
bit   ET1    	= 0xAB;
bit   EX1    	= 0xAA;
bit   ET0    	= 0xA9;
bit   EX0    	= 0xA8;

/*=========IP=========*/

bit   PC        = 0xBE;         /* D6 */
bit   PT2       = 0xBD;         /* D5 */
bit   PS        = 0xBC;         /* D4 */
bit   PT1       = 0xBB;         /* D3 */
bit   PX1       = 0xBA;         /* D2 */
bit   PT0       = 0xB9;         /* D1 */
bit   PX0       = 0xB8;         /* D0 */

/*=========P1=========*/

bit   C4EX      = 0x97;         /* p1.7 */
bit   C3EX      = 0x96;         /*   .6 */
bit   C2EX      = 0x95;         /*   .5 */
bit   C1EX      = 0x94;         /*   .4 */
bit   C0EX      = 0x93;         /*   .3 */
bit   C         = 0x92;         /*   .2: внешние такты счетчика PCA */
bit   T2EX      = 0x91;         /*   .1 */
bit   T2        = 0x90;         /* p1.0 */

/*=========P3=========*/

bit   RD     	= 0xB7;
bit   WR     	= 0xB6;
bit   T1     	= 0xB5;
bit   T0     	= 0xB4;
bit   INT1   	= 0xB3;
bit   INT0   	= 0xB2;
bit   TXD    	= 0xB1;
bit   RXD    	= 0xB0;

/*========SCON========*/

bit   SM0    	= 0x9F;
bit   SM1    	= 0x9E;
bit   SM2    	= 0x9D;
bit   REN    	= 0x9C;
bit   TB8    	= 0x9B;
bit   RB8    	= 0x9A;
bit   TI     	= 0x99;
bit   RI     	= 0x98;

/*========T2CON=======*/
bit   TF2       = 0xCF;
bit   EXF2      = 0xCE;
bit   RCLK      = 0xCD;
bit   TCLK      = 0xCC;
bit   EXEN2     = 0xCB;
bit   TR2    	= 0xCA;
bit   C_T2      = 0xC9;
bit   CP_RL2    = 0xC8;

/*========CCON========*/

bit   CF        = 0xDF;         /* переполнение счетчика PCA */
bit   CR        = 0xDE;         /* включение    счетчика PCA */
bit   CCF4      = 0xDC;         /* прерывание модуля 4 PCA */
bit   CCF3      = 0xDB;         /*                   3     */
bit   CCF2      = 0xDA;         /*                   2     */
bit   CCF1      = 0xD9;         /*                   1     */
bit   CCF0      = 0xD8;         /*                   0     */

/*==============================*/
/* Interrupt Vector Definitions */
/*==============================*/

interrupt [0x03] void EX0_int (void);	  /* External Interrupt 0 */

interrupt [0x0B] void T0_int (void);      /* Timer 0 Overflow */

interrupt [0x13] void EX1_int (void);	  /* External Interrupt 1 */

interrupt [0x1B] void T1_int (void);      /* Timer 1 Overflow */

interrupt [0x23] void SCON_int (void);    /* Serial Port */

interrupt [0x2B] void T2_int (void);      /* Timer 2 Overflow */

interrupt [0x2B] void T2EX_int (void);    /* Negative Transition on T2EX */

interrupt [0x33] void PCA_int (void);     /* модули и таймер/счетчик PCA */