/* Программа работы с носителями уникального кода DS1990A-F5
    (или просто идентификационными ключами iButton).
    од рассчитан на кварц 11.059 МГц */
#pragma language = extended
#include <include\io51fx.h>
#include <include\defines.h>
#include <include\settings.h>
#include <include\pins.h>
#include <include\vars.h>

extern uchar OrMask, AndMask;

extern uchar ReadRandom (uint Adr);
extern uchar ReadCurrent (uchar BlockAdr);
extern void WriteByte (uint Adr, uchar Byte);
extern void WriteBlock (uint Adr, uchar NumBytes, uchar* Src);

/*xdata uchar RDat [2048];

void ReadAll (void)
  {
   uint i;

   RDat[0] = ReadRandom(0);
   for (i=1;i<2048;i++)
      RDat[i] = ReadCurrent(i/256);
  }*/

void SetRedFlash (uchar OnDuration, uchar OffDuration)
  {
   OnRed  = OnDuration;
   OffRed = OffDuration;

   if (OnRed == 0)
      RED = TRUE;
  }

void setInt (void)
/* настройка системы прерываний и кишочков 8751 */
  {
/* TMOD:  режим работы таймеров/счетчиков (CT0, CT1). CT0 используем для
          формирования временных интервалов дискретизации,
          а CT1 не используется */
   #define CT1_16       0x10       /* 16-битный режим                 */
   #define CT1_8        0x20       /*  8-битный режим с автозагрузкой */
   #define CT0_16       0x01       /* 16-битный режим                 */
   #define CT0_8        0x02       /*  8-битный режим с автозагрузкой */
   TMOD = CT1_8+CT0_16;
   /* настроим таймер C/T0 */
   TH0 = T0_CONST/256;
   TL0 = (uchar)T0_CONST;
/* IE:    разрешение прерываний */
   #define ENL_INT0  0x01
   #define ENL_INT1  0x04
   #define ENL_SERIA 0x10
   #define ENL_TMR0  0x02
   #define ENL_TMR1  0x08
   IE = ENL_TMR0;

   EA = TRUE;
  }

void Clea24LC16 (void)
  {
   uchar ii;

   OrMask  = 0xFF;      /* в 24C16 будут писаться единички */
   for (ii=0;ii<(2048/16);ii++)
      WriteBlock(ii*16, 16, (uchar*)0);
   OrMask  = 0x00;      /* OrMask отключаем */

   MasterPresent = FALSE;       /* мастер-ключа в памяти нет */
   WriteByte (aMasterPresent, MasterPresent);
   OpenTime = 1;                /* время открывания 1 секунда */
   WriteByte (aOpenTime, OpenTime);
   NumKeys = 0;                 /* ни одного ключа в памяти */
   WriteByte (aNumKeys  , *((uchar*)&NumKeys  ));
   WriteByte (aNumKeys+1, *((uchar*)&NumKeys+1));
  }

void LoadFromEE (void)
  {
   MasterPresent = (ReadRandom(aMasterPresent) == TRUE);
   OpenTime      =  ReadRandom(aOpenTime);
   *((uchar*)&NumKeys  ) = ReadRandom (aNumKeys);
   *((uchar*)&NumKeys+1) = ReadCurrent(aNumKeys/256);
  }

void Beep (void)
  {
   uchar CopyCnt;

   ZUMM = FALSE;
   CopyCnt = Cnt50ms;
   while (CopyCnt==Cnt50ms){}
   while (CopyCnt!=Cnt50ms){}  /* длительность бипа 1 секунда */
   ZUMM = TRUE;
  }

void OpenDoor (void)
  {
   OpenTimeCnt = OpenTime * (1000/50);
  }

void ReadKey (uint Adr)
  {
   uchar i;

   for (i=0;i<4;i++)
      *((uchar*)&KeyF+i) = ReadRandom (Adr+i);
  }

void AddKey (void)
  {
   WriteBlock(NumKeys*4, 4, (uchar*)&KeyA);
   NumKeys++;
   WriteByte (aNumKeys  , *((uchar*)&NumKeys  ));
   WriteByte (aNumKeys+1, *((uchar*)&NumKeys+1));
  }

bit KeyExist (void)
/* Если ключ KeyA присутствует в 24C16, то возвращается TRUE.
   При этом IdxA хранит индекс (номер) ключа в 24C16 */
  {
   uint i;
   bit Result;

   Result = FALSE;
   for (i=0;i<NumKeys;i++)
     {
      ReadKey (i*4);
      if (KeyA==KeyF)
        {
         Result = TRUE;
         IdxA = i;
         break;
        }
     }
   return Result;
  }

void DeleteKey (void)
/* Удаляет из 24C16 ключ KeyA. При этом все данные в 24C16, находящиеся
   "правее", смещаются влево на 4 байта */
  {
   if (KeyExist())
     {
      IdxF = IdxA+1;
      while (IdxF<NumKeys)
        {
         ReadKey   (IdxF*4);
         WriteBlock(IdxA*4, 4, (uchar*)&KeyF);
         IdxA++;
         IdxF++;
        }
      KeyF = 0xFFFFFFFF;
      WriteBlock(IdxA*4, 4, (uchar*)&KeyF);
      NumKeys--;
      WriteByte (aNumKeys  , *((uchar*)&NumKeys  ));
      WriteByte (aNumKeys+1, *((uchar*)&NumKeys+1));
     }
  }

main()
  {
   RED   = FALSE;
   GREEN = FALSE;

   OrMask  = 0x00;      /* OrMask  отключаем */
   AndMask = 0xFF;      /* AndMask отключаем */
   Cnt50ms = 1000/50;   /* сколько раз должен будет отсчитать Cnt50ms, чтобы
                           прошло 1 сек */
   setInt();
   TR0 = TRUE;

   LoadFromEE();
/*ReadAll();*/

   RED   = TRUE;
   GREEN = TRUE;
   ZUMM = TRUE;
   SetRedFlash(1,1);

   while(TRUE)
     {
      if (SW0)/* перемычка СНЯТА */
        {
         if (ProgramMode)
           {
            if(KeyJoin)
              {
               if (JoinTime==0)
                 {
                  /* в этот момент ключ только что ПРИСОЕДИНИЛСЯ */
                  JoinTime++;
                 }
               if (JoinTime==1)
                 {
                  if (!KeyExist())
                    {
                     RED = FALSE;
                     AddKey();
                     Beep();
                     RED = TRUE;
                    }
                  else
                    {
                     DeleteKey();
                     Beep();
                    }
                  if (!ButtPressed)
                    {
                     ProgramMode=FALSE;
                     SetRedFlash(1,1);
                    }
                  JoinTime++;
                 }
              }
            else
            /* ключ не присоединён */
              {
               if (JoinTime!=0)
                 {/* в этот момент ключ только что ОТСОЕДИНИЛСЯ */
                  JoinTime = 0;
                 }
              }
           }/* if: ProgramMode */
         else
           {/* else: not ProgramMode */
            SetRedFlash(1,1);
            if (ButtPressed)
               OpenDoor();
            if(KeyJoin)
              {
               if(KeyExist())
                  OpenDoor();
               if(ButtPressed && MasterPresent)
                 {
                  ReadKey(aMaster);
                  if (KeyA==KeyF)
                    {
                     ProgramMode = TRUE;
                     SetRedFlash(0,0);
                    }
                 }
              }
           }/* else: not ProgramMode */
        }/* if: перемычка СНЯТА */
      else/* перемычка УСТАНОВЛЕНА! */
        {
         ProgramMode = FALSE;
         SetRedFlash(10,10);
         if (KeyJoin)
         /* ключ присоединён */
           {
            if (JoinTime==0)
              {
               /* в этот момент ключ только что ПРИСОЕДИНИЛСЯ */
               JoinTime++;
              }
            if (JoinTime==MasterSetTime)
              {
               /* пользователь держит ключ больше секунды.
                  Сделаем этот ключ мастер-ключом */
               ZUMM = FALSE;
               WriteBlock(aMaster, 4, (uchar*)&KeyA);
               WriteByte (aMasterPresent, TRUE);
               MasterPresent = TRUE;
               while(JoinTime<(MasterSetTime+MasterSetBeep)){}
               ZUMM = TRUE;
              }
            if (JoinTime==ClearTime)
              {
               /* пользователь держит ключ больше 29 секунд.
                  Полностью очищаем память */
               ZUMM = FALSE;
               Clea24LC16();
               while(JoinTime<ClearTime+ClearBeep){}
               ZUMM = TRUE;
              }
           }
         else
         /* ключ не присоединён */
           {
            if (JoinTime!=0)
              {/* в этот момент ключ только что ОТСОЕДИНИЛСЯ */
               JoinTime = 0;
              }
           }
         if (ButtPressed)
           {
            if (ButtTime==0)
              {
               /* в этот момент кнопка только что НАЖАТА */
               ButtTime++;
              }
            if (ButtTime==1)
              {
               ZUMM=FALSE;
               if (OpenTime==25)
                  OpenTime=1;
               else
                  OpenTime++;
               WriteByte (aOpenTime, OpenTime);
               Beep();
               ButtTime++;
              }
           }
         else
           {
            if (ButtTime!=0)
              {/* в этот момент кнопка только что ОТПУЩЕНА */
               ButtTime = 0;
              }
           }
        }/* else: перемычка УСТАНОВЛЕНА! */
     }
  }
