#pragma language = extended
#include <include\io51fx.h>
#include <include\defines.h>
#include <include\settings.h>
#include <include\pins.h>
extern bit I2CERR;
extern bit   SHOUT     (void);   /* посылаем  байт из ACC */
extern void  SHIN      (void);   /* принимаем байт в  ACC */
extern bit   STARTCOND (void);
extern bit   POS_ACK   (void);
extern void  NEG_ACK   (void);
extern void  STOPCOND  (void);
#define FixAdr   0xA0   /* фиксированный адрес для EEPROM с I2C      */
#define maxTry   120    /* максимальное количество попыток
                            доступа к шине I2C */

uchar OrMask, AndMask;  /* маски для данных, записываемых с помощью WriteBlock */

void WaitEndWriteCycle (void)
  {
   uchar RetryCnt;

   for(RetryCnt=maxTry;RetryCnt!=0;RetryCnt--)
     {
      STARTCOND();      /* посылаем START */
      ACC = FixAdr;
      I2CERR = SHOUT(); /* посылаем команду записи */

      if (!I2CERR)
        {               /* запись окончена! */
         STOPCOND();    /* посылаем STOP */
         break;         /* всё готово для дальнейшей работы */
        }
     }/* ожидаем, когда закончится цикл записи */
  }

void WriteBlock (uint Adr, uchar NumBytes, uchar* Src)
/* использует для ускорения записи режим Page Write микросхем 24C08B/16B
   фирмы Microchip; NumBytes должно быть 1..16 */
  {
   uchar tmpByte;

   WaitEndWriteCycle();
   if(I2CERR)
      return;

   I2CERR = STARTCOND();
   if(I2CERR)
      return;

   tmpByte = Adr/256;
   ACC = (tmpByte << 1) | FixAdr;
                        /* поместим программируемый адрес в биты 3..1
                            и добавим фиксированный адрес */
   ACC &= 0xfe;         /* укажем операцию записи  */
   if (SHOUT())         /* пошлем адрес устройств  */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }
   ACC = (uchar)Adr;
   if (SHOUT())      /* посылаем адрес */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   ACC = ((*Src|OrMask)&AndMask);
   if (SHOUT())      /* посылаем байт данных */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   Src++;
   NumBytes--;

   while (NumBytes != 0)
     {
      ACC = ((*Src|OrMask)&AndMask);
      if (SHOUT())      /* посылаем байт данных */
        {
         STOPCOND();
         I2CERR=TRUE;
         return;
        }/* if: вываливаемся, если нет подтверждения */
      Src++;
      NumBytes--;
     }
   STOPCOND();
   I2CERR=FALSE;
   return;
  }

void WriteByte (uint Adr, uchar Byte)
/* Программулина пишет байт Byte по адресу Adr. При возврате установленный
    I2CERR означает занятость шины или ошибочное подтверждение адресуемого
    устройства. */
  {
   uchar tmpByte;

   WaitEndWriteCycle();
   if(I2CERR)
      return;

   I2CERR = STARTCOND();
   if(I2CERR)
      return;

   tmpByte = Adr/256;
   ACC = (tmpByte << 1) | FixAdr;
                        /* поместим программируемый адрес в биты 3..1
                            и добавим фиксированный адрес */
   ACC &= 0xfe;         /* укажем операцию записи  */
   if (SHOUT())         /* пошлем адрес устройств  */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   ACC = (uchar)Adr;
   if (SHOUT())      /* посылаем адрес */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   ACC = Byte;
   if (SHOUT())      /* посылаем байт данных */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   STOPCOND();
   I2CERR=FALSE;
   return;
  }

uchar ReadCurrent (uchar BlockAdr)
/* Читаем байт по текущему адресу. При возврате установленный
    I2CERR означает занятость шины или ошибочное подтверждение адресуемого
    устройства. */
  {
   uchar tmpByte;

   I2CERR = STARTCOND();
   if(I2CERR)
      return;

   tmpByte = BlockAdr;
   ACC = (tmpByte << 1) | FixAdr;
                        /* поместим программируемый адрес в биты 3..1
                            и добавим фиксированный адрес */
   ACC |= 0x01;         /* укажем операцию чтения  */
   if (SHOUT())         /* пошлем адрес устройств  */
     {
      STOPCOND();
      I2CERR=TRUE;
      return 0;
     }/* if: вываливаемся, если нет подтверждения */
   SHIN();      /* примем байт данных в ACC             */
   NEG_ACK();   /* не выдаем подтвержление байта        */
   I2CERR = FALSE; /* очищаем флаг ошибки                  */
   STOPCOND();
   return ACC;
  }

uchar ReadRandom (uint Adr)
/* Читаем байт по произвольному адресу Adr. При возврате установленный
    I2CERR означает занятость шины или ошибочное подтверждение адресуемого
    устройства. */
  {
   uchar tmpByte;

   WaitEndWriteCycle();
   if(I2CERR)
      return;

   I2CERR = STARTCOND();
   if(I2CERR)
      return;

   tmpByte = Adr/256;
   ACC = (tmpByte << 1) | FixAdr;
                        /* поместим программируемый адрес в биты 3..1
                            и добавим фиксированный адрес */
   ACC &= 0xfe;         /* укажем операцию записи (на самом деле
                            писать не будем, это нужно только для
                            переустановки адреса */
   if (SHOUT())         /* пошлем адрес устройства */
     {
      STOPCOND();
      I2CERR=TRUE;
      return 0;
     }/* if: вываливаемся, если нет подтверждения */
   ACC = (uchar)Adr;
   if (SHOUT())      /* посылаем адрес */
     {
      STOPCOND();
      I2CERR=TRUE;
      return;
     }/* if: вываливаемся, если нет подтверждения */
   ACC = ReadCurrent(Adr/256);
   return ACC;
  }

/*void LoadFromEE (bit TestCRC)
  {
   uchar Adress;
   uint  Summa;
   uchar IEacc;

   IEacc = IE;
   IE = 0;

   Adress = 0;
   SysMem[Adress]=ReadRandom24C02(Adress);
   Adress++;
   while (Adress!=0)
     {
      SysMem[Adress]=ReadCurrent();
      Adress++;
      if (I2CERR)
        {
         IE = IEacc;
         ErrorCycle();
        }
     }
   IE = IEacc;
   if (TestCRC)
     {
      Summa = CRC_DATA (SysMem, sizeof(SysMem)-2);
      if (Summa != SysMem[254]*256 + SysMem[255])
         ErrorCycle();
     }
  }

void SaveToEE (void)
  {
   uchar Adress;
   uint  Summa;
   uchar IEacc;

   IEacc = IE;
   IE = 0;

   Summa = CRC_DATA (SysMem, sizeof(SysMem)-2);
   SysMem[254] = Summa/256;
   SysMem[255] = (uchar)Summa;
   Adress = 0;
   wbWriteByte24C02 (Adress, SysMem[Adress]);
   Adress++;
   while (Adress!=0)
     {
      wbWriteByte24C02 (Adress, SysMem[Adress]);
      Adress++;
      if (I2CERR)
        {
         IE = IEacc;
         ErrorCycle();
        }
     }
   IE = IEacc;
  }*/

