/*
   обработчик прерывания для C/T0
*/
#pragma language = extended
#include <..\..\c51.my\include\io51fx.h>
#include <include\defines.h>
#include <include\settings.h>
#include <include\pins.h>

extern uchar Cnt50ms, Time, JoinTime, ButtTime;
extern uint OpenTimeCnt;
extern bit   TouchReset (void);
extern uchar TouchByte  (uchar OutByte);
extern bit KeyJoin, ButtPressed;
extern ulong KeyA;
extern uchar CRC;
extern uchar OnRed, OffRed, FlashCnt;

extern void  DO_CRC (uchar ToAdd);

bit GetKey (void)
  {
   uchar i;
   uchar ReadedCRC;

   CRC = 0;
   TouchByte(ReadROM);
   DO_CRC(TouchByte(0xFF));  /* получили код устройства (==01h) */
   for (i=3; i!=0xFF; i--)
     {
      *((uchar*)(&KeyA) +i) = TouchByte(0xFF);
      DO_CRC(*((uchar*)(&KeyA) +i));
     }
   for (i=0; i<2; i++)
      DO_CRC(TouchByte(0xFF));
   ReadedCRC = TouchByte(0xFF);
   return (CRC == ReadedCRC);
  }

interrupt void T0_int()
  {
   TH0 = T0_CONST/256;
   TL0 = (uchar)T0_CONST;

   if (OpenTimeCnt!=0)
     {
      GREEN = FALSE;
      OpenTimeCnt--;
     }
   else
      GREEN = TRUE;

   if (Cnt50ms!=0)
      Cnt50ms--;
   else
     {
      Cnt50ms = 1000/50;
      if (Time!=0)
         Time--;
      if ((JoinTime!=0) && (JoinTime!=0xFF))
         JoinTime++;
      if ((ButtTime!=0) && (ButtTime!=0xFF))
         ButtTime++;
     }

   if (OnRed!=0)
     {
      if (FlashCnt==0)
        {
         if(RED)
           {
            RED = FALSE;
            FlashCnt = OnRed;
           }
         else
           {
            RED = TRUE;
            FlashCnt = OffRed;
           }
        }
      else
         FlashCnt--;
     }

   if (TouchReset() && GetKey())
      /* обнаружено подсоединение ключа! */
      KeyJoin = TRUE;
   else
      KeyJoin = FALSE;

   if (BUTTON)
      ButtPressed = FALSE;
   else
      ButtPressed = TRUE;
  }
